import { defineStore } from "pinia";
import { ref } from "vue";
import axios from 'axios';
import router from '../Router';
import Echo from "laravel-echo";

export const useAuthStore = defineStore("auth", () => {
    const token = ref(localStorage.getItem('token'));
    const refreshToken = ref(localStorage.getItem('refresh_token'));
    const user = ref(JSON.parse(localStorage.getItem('user')));
    const isAuth = ref(false);

    function setToken(tokenValue) {
        localStorage.setItem('token', tokenValue);
        token.value = tokenValue;
    }
    function setRefreshToken(tokenValue) {
        localStorage.setItem('refresh_token', tokenValue);
        refreshToken.value = tokenValue;
    }
    function getToken() {
        return token?.value;
    }
    function getRefreshToken() {
        return refreshToken?.value;
    }
    function setUser(userValue) {
        if(userValue != null) {
            localStorage.setItem('user', JSON.stringify(userValue));
            user.value = userValue;
        }
    }
    function setIsAuth(auth) {
        isAuth.value = auth;
    }
    async function checkToken() {
        try {
            const tokenAuth = 'Bearer ' + token.value;
            const { data } = await axios.get('/api/auth/verify', {
                headers: {
                    Authorization: tokenAuth
                }
            });
            return data;
        } catch (error) {
            if(error.response.status === 401) {
                logout();
                router.push('/');
            }else{
                console.log(error.response);
            }
        }
    }
    function logout() {
        localStorage.removeItem('token');
        localStorage.removeItem('refresh_token');
        localStorage.removeItem('user');
        token.value = '';
        refreshToken.value = '';
        user.value = '';
        isAuth.value = false;
    }
    function initializingEcho() {
        window.EchoPrivate = new Echo({
            broadcaster: 'pusher',
            key: import.meta.env.VITE_PUSHER_APP_KEY,
            cluster: import.meta.env.VITE_PUSHER_APP_CLUSTER ?? 'mt1',
            wsHost: import.meta.env.VITE_PUSHER_HOST ? import.meta.env.VITE_PUSHER_HOST : `ws-${import.meta.env.VITE_PUSHER_APP_CLUSTER}.pusher.com`,
            wsPort: import.meta.env.VITE_PUSHER_PORT ?? 80,
            forceTLS: false,
            enabledTransports: ['ws', 'wss'],
            disabledTransports: ['sockjs', 'xhr_polling', 'xhr_streaming'],
            authEndpoint: `/api/broadcasting/auth`,
            auth: {
                headers: {
                    'X-CSRF-TOKEN': document.head.querySelector('meta[name="csrf-token"]'),
                    Authorization: `Bearer ${token.value}`
                }
            }
        });
    }
    return {
        token,
        refreshToken,
        user,
        isAuth,
        setToken,
        setRefreshToken,
        getToken,
        getRefreshToken,
        setUser,
        setIsAuth,
        checkToken,
        logout,
        initializingEcho
    };
});
